/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.common;

import com.gfactory.gts.minecraft.GTS;
import com.gfactory.gts.pack.GTSMemoryResourcePack;
import com.gfactory.gts.pack.GTSPack;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResourcePack;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.ProgressManager;

public class GTSPackLoader {
    private final ArrayList<GTSPack> packs = new ArrayList();

    public GTSPackLoader() {
        this.packs.add(GTSPack.getDummyPack());
    }

    public void searchPacks(File file) {
        if (file == null) {
            return;
        }
        GTS.LOGGER.info(I18n.func_135052_a((String)"gts.message.pack_search.start", (Object[])new Object[]{file.getAbsolutePath()}));
        File[] files = file.listFiles((dir, name) -> name.endsWith(".zip"));
        if (files == null) {
            GTS.LOGGER.info(I18n.func_135052_a((String)"gts.message.pack_search.notfound", (Object[])new Object[0]));
            return;
        }
        GTS.LOGGER.info(I18n.func_135052_a((String)"gts.message.pack_search.zip_count", (Object[])new Object[]{files.length}));
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"GTS Pack Search", (int)files.length);
        for (File f : files) {
            bar.step(f.getName());
            try (FileInputStream fis = new FileInputStream(f);
                 ZipInputStream zis = new ZipInputStream(fis);){
                GTSPack pack = this.load(zis, f);
                GTS.LOGGER.debug(pack.toString());
                if (pack.empty()) {
                    GTS.LOGGER.warn(I18n.func_135052_a((String)"gts.message.pack_search.error.empty", (Object[])new Object[]{f.getName()}));
                    continue;
                }
                this.packs.add(pack);
            }
            catch (IOException e) {
                GTS.LOGGER.error(I18n.func_135052_a((String)"gts.message.pack_search.error.zip", (Object[])new Object[]{f.getName()}));
            }
        }
        this.loadAudio();
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
        GTS.LOGGER.info(I18n.func_135052_a((String)"gts.message.pack_search.finish", (Object[])new Object[]{this.packs.size()}));
    }

    private GTSPack load(ZipInputStream zis, File file) throws IOException {
        GTS.LOGGER.info(I18n.func_135052_a((String)"gts.message.pack_load.start", (Object[])new Object[]{file.getName()}));
        GTSPack p = GTSPack.load(zis, file);
        GTS.LOGGER.debug(p.toString());
        return p;
    }

    public GTSPack getPack(String name) {
        for (GTSPack pack : this.packs) {
            if (!pack.getName().equals(name)) continue;
            return pack;
        }
        return null;
    }

    public GTSPack getDummy() {
        if (this.packs.isEmpty()) {
            return null;
        }
        GTSPack p = this.packs.get(0);
        return p.dummy() ? p : null;
    }

    public ArrayList<GTSPack> getPacks() {
        return this.packs;
    }

    public void loadAudio() {
        for (GTSPack pack : this.packs) {
            this.addDefaultResourcePack(new GTSMemoryResourcePack(pack));
        }
        Minecraft.func_71410_x().func_110436_a();
    }

    private void addDefaultResourcePack(IResourcePack pack) {
        List l = (List)ObfuscationReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String[])new String[]{"defaultResourcePacks", "field_110449_ao"});
        l.add(pack);
    }
}

