/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.minecraft.renderer;

import com.gfactory.core.mqo.MQO;
import com.gfactory.core.mqo.MQOObject;
import com.gfactory.gts.minecraft.GTS;
import com.gfactory.gts.minecraft.renderer.GTSTileEntityRenderer;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntityTrafficArm;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntityTrafficPole;
import com.gfactory.gts.pack.GTSPack;
import com.gfactory.gts.pack.config.GTSConfig;
import com.gfactory.gts.pack.config.GTSTrafficArmConfig;
import com.gfactory.gts.pack.config.GTSTrafficPoleConfig;
import java.util.ArrayList;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class GTSTileEntityTrafficPoleRenderer
extends GTSTileEntityRenderer<GTSTileEntityTrafficPole, GTSTrafficPoleConfig> {
    @Override
    public void renderModel(GTSTileEntityTrafficPole te, GTSPack pack, GTSTrafficPoleConfig config, Tessellator t, MQO model, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        ArrayList<String> obj2;
        ResourceLocation textureBase = pack.getOrCreateBindTexture(((GTSConfig.GTSTexture)config.getTextures()).getBase());
        if (textureBase == null) {
            GTS.LOGGER.warn(I18n.func_135052_a((String)"gts.warning.texture_cannot_load", (Object[])new Object[]{"Some Texture"}));
            return;
        }
        this.func_147499_a(textureBase);
        ArrayList<String> obj = config.getNormalObject();
        if (te.isUpJoint() && !te.isBottomJoint()) {
            obj2 = config.getUpJointObject();
            if (obj2 != null) {
                obj = obj2;
            }
        } else if (!te.isUpJoint() && te.isBottomJoint()) {
            obj2 = config.getBottomJointObject();
            if (obj2 != null) {
                obj = obj2;
            }
        } else if (te.isUpJoint() && te.isBottomJoint() && (obj2 = config.getFullJointObject()) != null) {
            obj = obj2;
        }
        for (MQOObject o : model.getObjects()) {
            if (!obj.contains(o.getName())) continue;
            o.draw();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GL11.glTranslated((double)(x + 0.5 + te.getPosX() * Math.cos(te.getAngle()) + te.getPosZ() * Math.sin(te.getAngle())), (double)(y + 0.5 + te.getPosY()), (double)(z + 0.5 + te.getPosZ() * Math.cos(te.getAngle()) + te.getPosX() * Math.sin(te.getAngle())));
        for (GTSTileEntityTrafficArm arm : te.getJointArms()) {
            ResourceLocation armTex;
            GTSTrafficArmConfig armConfig;
            GTSPack armPack = arm.getPack();
            if (armPack == null || (armConfig = (GTSTrafficArmConfig)arm.getConfig()) == null || armConfig.getTextures() == null || (armTex = armPack.getOrCreateBindTexture(((GTSConfig.GTSTexture)armConfig.getTextures()).getBase())) == null) continue;
            this.func_147499_a(armTex);
            MQO armModel = armPack.getResizingModels(armConfig.getModel(), armConfig.getSize());
            if (armModel == null) continue;
            Vec3d startPos = new Vec3d((double)te.func_174877_v().func_177958_n(), (double)te.func_174877_v().func_177956_o(), (double)te.func_174877_v().func_177952_p());
            Vec3d endPos = new Vec3d((double)arm.func_174877_v().func_177958_n(), (double)arm.func_174877_v().func_177956_o(), (double)arm.func_174877_v().func_177952_p());
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            Vec3d delta = endPos.func_178788_d(startPos).func_72432_b();
            double length = Math.sqrt(Math.pow(startPos.field_72450_a - endPos.field_72450_a, 2.0) + Math.pow(startPos.field_72448_b - endPos.field_72448_b, 2.0) + Math.pow(startPos.field_72449_c - endPos.field_72449_c, 2.0));
            double baseLength = length - armConfig.getSize() * 2.0;
            double yaw = Math.toDegrees(Math.atan2(delta.field_72450_a, delta.field_72449_c));
            double pitch = Math.toDegrees(-Math.asin(delta.field_72448_b));
            GlStateManager.func_179114_b((float)((float)yaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)pitch), (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)(armConfig.getSize() / 2.0), (double)0.0, (double)0.0);
            if (baseLength >= armConfig.getSize() || armConfig.isDrawStartPrimary()) {
                for (MQOObject o : armModel.getObjects()) {
                    if (!armConfig.getEdgeObjects().contains(o.getName())) continue;
                    o.draw();
                }
            }
            GlStateManager.func_179137_b((double)(baseLength / 2.0 + armConfig.getSize() / 2.0), (double)0.0, (double)0.0);
            GlStateManager.func_179139_a((double)(baseLength / armConfig.getSize() * 1.2), (double)1.0, (double)1.0);
            if (baseLength >= 0.0) {
                for (MQOObject o : armModel.getObjects()) {
                    if (!armConfig.getBaseObjects().contains(o.getName())) continue;
                    o.draw();
                }
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)yaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)pitch), (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)(length - armConfig.getSize() / 2.0), (double)0.0, (double)0.0);
            for (MQOObject o : armModel.getObjects()) {
                if (!armConfig.getEndObjects().contains(o.getName())) continue;
                o.draw();
            }
            GlStateManager.func_179121_F();
        }
    }
}

