/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.tool;

import com.gfactory.gts.tool.component.GTSMainTabPane;
import com.gfactory.gts.tool.component.GTSMenuBar;
import com.gfactory.gts.tool.component.GTSSideTreeView;
import com.gfactory.gts.tool.helper.I18n;
import com.gfactory.gts.tool.project.GTSPackProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;

public class GTSPackMaker {
    public static JFrame window = new JFrame();
    public static final String VERSION = "0.1b - GTS2.0";
    public static GTSMenuBar menuBar;
    public static JLabel statusBar;
    public static JProgressBar progressBar;
    public static GTSSideTreeView sideView;
    public static GTSMainTabPane mainView;
    public static GTSPackMakerConfig config;
    public static GTSPackProject project;

    public static void main(String[] args) {
        GTSPackMaker.init();
        window.getContentPane().revalidate();
        window.getContentPane().repaint();
    }

    public static void init() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            SwingUtilities.updateComponentTreeUI(window);
        }
        catch (Exception e) {
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
                SwingUtilities.updateComponentTreeUI(window);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        window.setTitle(I18n.format("core.title", VERSION));
        window.setSize(config.getWindowSize());
        window.setDefaultCloseOperation(3);
        window.setLocationRelativeTo(null);
        menuBar = new GTSMenuBar(window);
        window.setJMenuBar(menuBar);
        window.setVisible(true);
        statusBar = new JLabel(I18n.format("status.noProjectOpen", new String[0]));
        statusBar.setHorizontalTextPosition(2);
        JPanel statusPanel = new JPanel(new BorderLayout(5, 5));
        statusPanel.setBorder(new EtchedBorder());
        statusPanel.add((Component)statusBar, "West");
        progressBar = new JProgressBar();
        progressBar.setPreferredSize(new Dimension(GTSPackMaker.config.getWindowSize().width / 4, 20));
        progressBar.setMaximum(100);
        progressBar.setMinimum(0);
        statusPanel.add((Component)progressBar, "East");
        window.getContentPane().add((Component)statusPanel, "South");
        sideView = new GTSSideTreeView();
        window.getContentPane().add((Component)sideView, "West");
        mainView = new GTSMainTabPane();
        window.getContentPane().add((Component)mainView, "Center");
    }

    static {
        config = new GTSPackMakerConfig();
    }

    public static class GTSPackMakerConfig {
        private int[] size = new int[]{1280, 720};

        public Dimension getWindowSize() {
            return new Dimension(this.size[0], this.size[1]);
        }
    }
}

