/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.minecraft.gui;

import com.gfactory.gts.common.controller.GTSCycle;
import com.gfactory.gts.minecraft.GTS;
import com.gfactory.gts.minecraft.gui.GTSGuiModelChoose;
import com.gfactory.gts.minecraft.network.packet.GTSPacketTileEntity;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntity;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntityTrafficController;
import com.gfactory.gts.pack.GTSPack;
import com.gfactory.gts.pack.config.GTSConfig;
import com.gfactory.gts.pack.config.GTSTrafficControllerConfig;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;

public class GTSGuiTrafficController
extends GTSGuiModelChoose<GTSTileEntityTrafficController> {
    private String errorMessage = "";

    public GTSGuiTrafficController(GTSTileEntity tileEntity) {
        super(tileEntity);
    }

    @Override
    public TreeMap<String, ? extends GTSConfig> getModelElements() {
        TreeMap<String, GTSTrafficControllerConfig> elements = new TreeMap<String, GTSTrafficControllerConfig>();
        for (GTSPack p : GTS.LOADER.getPacks()) {
            for (Map.Entry<String, GTSConfig<GTSConfig.GTSTexture>> e : p.getConfigs().entrySet()) {
                if (!(e.getValue() instanceof GTSTrafficControllerConfig)) continue;
                GTSTrafficControllerConfig c = (GTSTrafficControllerConfig)e.getValue();
                elements.put(p.getName() + ": " + c.getId(), c);
            }
        }
        return elements;
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == 1) {
            SwingUtilities.invokeLater(() -> {
                JFrame dummyFrame = new JFrame();
                dummyFrame.setAlwaysOnTop(true);
                dummyFrame.setUndecorated(true);
                dummyFrame.setLocationRelativeTo(null);
                dummyFrame.setVisible(true);
                JFileChooser fc = new JFileChooser(Minecraft.func_71410_x().field_71412_D);
                fc.addChoosableFileFilter(new FileNameExtensionFilter(I18n.func_135052_a((String)"gts.gui.controller.extension", (Object[])new Object[0]), "gts"));
                int result = fc.showDialog(dummyFrame, I18n.func_135052_a((String)"gts.gui.controller.load", (Object[])new Object[0]));
                if (result != 0) {
                    dummyFrame.dispose();
                    return;
                }
                File file = fc.getSelectedFile();
                dummyFrame.dispose();
                if (file == null) {
                    return;
                }
                try (FileReader fr = new FileReader(file);){
                    GTSCycle[] cycle = (GTSCycle[])GTS.GSON.fromJson((Reader)fr, GTSCycle[].class);
                    GTSTileEntityTrafficController te = (GTSTileEntityTrafficController)this.tileEntity;
                    te.setCycles(new ArrayList<GTSCycle>(Arrays.asList(cycle)));
                    te.func_70296_d();
                    GTS.NETWORK.sendToServer(new GTSPacketTileEntity<GTSTileEntityTrafficController>(te.func_189515_b(new NBTTagCompound()), te.func_174877_v(), GTSTileEntityTrafficController.class));
                    this.errorMessage = I18n.func_135052_a((String)"gts.gui.controller.load.done", (Object[])new Object[0]);
                }
                catch (JsonParseException | IOException e) {
                    this.errorMessage = I18n.func_135052_a((String)"gts.gui.controller.load.error", (Object[])new Object[]{e.getLocalizedMessage()});
                }
            });
        } else if (button.field_146127_k == 2) {
            JFrame dummyFrame = new JFrame();
            dummyFrame.setAlwaysOnTop(true);
            dummyFrame.setUndecorated(true);
            dummyFrame.setLocationRelativeTo(null);
            dummyFrame.setVisible(true);
            SwingUtilities.invokeLater(() -> {
                JFileChooser fc = new JFileChooser(Minecraft.func_71410_x().field_71412_D);
                fc.addChoosableFileFilter(new FileNameExtensionFilter(I18n.func_135052_a((String)"gts.gui.controller.extension", (Object[])new Object[0]), "gts"));
                int result = fc.showDialog(dummyFrame, I18n.func_135052_a((String)"gts.gui.controller.save", (Object[])new Object[0]));
                if (result != 0) {
                    dummyFrame.dispose();
                    return;
                }
                File file = fc.getSelectedFile();
                if (file == null) {
                    return;
                }
                try (FileWriter fw = new FileWriter(file);){
                    GTSTileEntityTrafficController te = (GTSTileEntityTrafficController)this.tileEntity;
                    String data = GTS.GSON.toJson((Object)te.getCycles().toArray(), GTSCycle[].class);
                    fw.write(data);
                    this.errorMessage = I18n.func_135052_a((String)"gts.gui.controller.save.done", (Object[])new Object[0]);
                }
                catch (JsonParseException | IOException e) {
                    this.errorMessage = I18n.func_135052_a((String)"gts.gui.controller.save.error", (Object[])new Object[]{e.getLocalizedMessage()});
                }
            });
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.func_189646_b(new GuiButton(1, this.field_146294_l / 2 + 2, this.field_146289_q.field_78288_b + 2, this.field_146294_l / 2 - 4, 20, I18n.func_135052_a((String)"gts.gui.controller.load", (Object[])new Object[0])));
        this.func_189646_b(new GuiButton(2, this.field_146294_l / 2 + 2, this.field_146289_q.field_78288_b + 4 + 20, this.field_146294_l / 2 - 4, 20, I18n.func_135052_a((String)"gts.gui.controller.save", (Object[])new Object[0])));
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_73731_b(this.field_146289_q, this.errorMessage, this.field_146294_l / 2 + 2, this.field_146289_q.field_78288_b + 6 + 40, 0xFFFF00);
    }

    @Override
    public void func_146274_d() throws IOException {
        super.func_146274_d();
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }
}

