/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.common;

import com.gfactory.gts.minecraft.GTS;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class GTSSignTextureManager {
    private static GTSSignTextureManager instance;
    private final HashMap<GTS114Sign, ResourceLocation> sign114 = new HashMap();
    private final HashMap<GTS114Sign, BufferedImage> sign114Original = new HashMap();
    private final ConcurrentHashMap<GTS114Sign, Future<BufferedImage>> pendingTasks = new ConcurrentHashMap();
    private final ExecutorService executor = Executors.newFixedThreadPool(4);
    public static final GTS114Sign PLACE_HOLDER_INFO;
    public static ResourceLocation PLACE_HOLDER;

    private GTSSignTextureManager() {
        this.createThread(PLACE_HOLDER_INFO, true);
    }

    public static GTSSignTextureManager getInstance() {
        if (instance == null) {
            instance = new GTSSignTextureManager();
        }
        return instance;
    }

    private void createThread(GTS114Sign info, boolean dummy) {
        Callable<BufferedImage> task = () -> this.createTexture(info);
        Future<BufferedImage> future = this.executor.submit(task);
        this.pendingTasks.put(info, future);
        this.executor.submit(() -> {
            block8: {
                try {
                    BufferedImage result = (BufferedImage)future.get();
                    if (result == null) break block8;
                    HashMap<GTS114Sign, BufferedImage> hashMap = this.sign114Original;
                    synchronized (hashMap) {
                        this.sign114Original.put(info, result);
                        Minecraft.func_71410_x().func_152344_a(() -> {
                            ResourceLocation r = Minecraft.func_71410_x().func_110434_K().func_110578_a(info.toString(), new DynamicTexture(result));
                            if (!dummy) {
                                HashMap<GTS114Sign, ResourceLocation> hashMap = this.sign114;
                                synchronized (hashMap) {
                                    this.sign114.put(info, r);
                                }
                            } else {
                                PLACE_HOLDER = r;
                            }
                        });
                    }
                }
                catch (Exception e) {
                    GTS.LOGGER.warn(I18n.func_135052_a((String)"gts.exception.texture.create", (Object[])new Object[]{e.getLocalizedMessage()}));
                }
                finally {
                    this.pendingTasks.remove(info);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceLocation getResourceLocation(GTS114Sign info) {
        HashMap<GTS114Sign, ResourceLocation> hashMap = this.sign114;
        synchronized (hashMap) {
            if (this.sign114.containsKey(info)) {
                return this.sign114.get(info);
            }
        }
        if (!this.pendingTasks.containsKey(info)) {
            this.createThread(info, false);
        }
        return PLACE_HOLDER;
    }

    public BufferedImage getBufferedTexture(GTS114Sign info) {
        if (this.sign114.containsKey(info)) {
            return this.sign114Original.get(info);
        }
        this.createTexture(info);
        return this.sign114Original.get(info);
    }

    private BufferedImage createTexture(GTS114Sign info) {
        int res = 512;
        ArrayList<String> fonts = GTSSignTextureManager.getAvailableFonts();
        Font japaneseFont = new Font("SansSerif", 0, 200);
        if (fonts.contains(info.japaneseFont)) {
            japaneseFont = new Font(info.japaneseFont, 0, 200);
        }
        Font englishFont = new Font("SansSerif", 0, 100);
        if (fonts.contains(info.englishFont)) {
            englishFont = new Font(info.englishFont, 1, 100);
        }
        FontRenderContext jpFrc = new FontRenderContext(null, true, true);
        FontRenderContext enFrc = new FontRenderContext(null, true, true);
        TextLayout jpTl = new TextLayout(info.japanese, japaneseFont, jpFrc);
        TextLayout enTl = new TextLayout(info.english, englishFont, enFrc);
        float jpWidth = jpTl.getAdvance() / (float)info.japanese.length();
        float enWidth = enTl.getAdvance();
        res = 520;
        int MARGIN = 20;
        int borderWidth = 10;
        int paddingWidthEdge = 70;
        int paddingHeightEdge = 60;
        int paddingText = 40;
        int jpEnGap = 40;
        float enScale = 0.8f;
        float jpScale = 1.0f;
        int width = 0;
        int jpPadding = 0;
        if (info.widthFix) {
            width = (int)((double)res * info.aspect);
            if (((float)(paddingText * (info.japanese.length() - 1)) + jpWidth * (float)info.japanese.length()) * jpScale > (float)(width - MARGIN * 2 - borderWidth * 2 - paddingWidthEdge * 2)) {
                paddingWidthEdge = 35;
                paddingText = 20;
                jpScale = (float)(width - MARGIN * 2 - borderWidth * 2 - paddingWidthEdge * 2) / ((float)(paddingText * (info.japanese.length() - 1)) + jpWidth * (float)info.japanese.length());
            } else {
                float gap = Math.abs(((float)(paddingText * (info.japanese.length() - 1)) + jpWidth * (float)info.japanese.length()) * jpScale - (float)(width - MARGIN * 2 - borderWidth * 2 - paddingWidthEdge * 2));
                jpPadding = (int)(gap / 2.0f);
            }
        } else {
            width = info.japanese.length() * 200 + (info.japanese.length() - 1) * paddingText + borderWidth * 2 + MARGIN * 2 + paddingWidthEdge * 2;
        }
        if (enWidth * enScale > (float)(width - MARGIN * 2 - borderWidth * 2 - paddingWidthEdge * 2)) {
            enScale = (float)(width - MARGIN * 2 - borderWidth * 2 - paddingWidthEdge * 2) / enWidth;
        }
        BufferedImage image = new BufferedImage(width, res, 5);
        Graphics2D g = image.createGraphics();
        AffineTransform origin = g.getTransform();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(info.color);
        g.fillRect(0, 0, width, res);
        g.setColor(info.textColor);
        g.setStroke(new BasicStroke(borderWidth));
        g.drawRoundRect(MARGIN, MARGIN, width - MARGIN * 2, res - MARGIN * 2, MARGIN, MARGIN);
        g.setFont(japaneseFont);
        g.scale(jpScale, 1.0);
        int y = (int)((float)(MARGIN + borderWidth + paddingHeightEdge) + jpTl.getAscent() + jpTl.getDescent());
        for (int i = 0; i < info.japanese.length(); ++i) {
            char text = info.japanese.charAt(i);
            int x = (int)((float)jpPadding + ((float)MARGIN / jpScale + (float)borderWidth / jpScale + (float)paddingWidthEdge / jpScale + (float)(i * paddingText) + (float)(i * 200)));
            g.setStroke(new BasicStroke(1.0f));
            g.drawString(String.valueOf(text), x, y);
        }
        g.setTransform(origin);
        g.scale(enScale, 1.0);
        int x = (int)(((double)width / 2.0 - (double)(enWidth * enScale) / 2.0) / (double)enScale);
        y = MARGIN + borderWidth + paddingHeightEdge + 200 + paddingText + 100;
        g.setFont(englishFont);
        enTl.draw(g, x, y);
        g.setTransform(origin);
        BufferedImage resizeImage = new BufferedImage(1024, 1024, 5);
        Graphics2D rg = resizeImage.createGraphics();
        rg.setColor(info.color);
        rg.fillRect(0, 0, 1024, 1024);
        rg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        rg.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        rg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        rg.drawImage(image, 0, 0, 922, 461, null);
        return resizeImage;
    }

    public static ArrayList<String> getAvailableFonts() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return new ArrayList<String>(Arrays.asList(ge.getAvailableFontFamilyNames()));
    }

    public static void main(String[] args) {
        GTSSignTextureManager manager = GTSSignTextureManager.getInstance();
        GTS114Sign info = new GTS114Sign();
        info.widthFix = true;
        manager.createTexture(info);
    }

    static {
        PLACE_HOLDER_INFO = new GTS114Sign();
    }

    public static class GTS114Sign {
        public String japanese = "\u751f\u6210\u4e2d";
        public String english = "Generating";
        public Color color = new Color(255, 255, 255);
        public Color textColor = new Color(0, 0, 255);
        public String japaneseFont = "A-SK Nar Min2 E";
        public String englishFont = "Helvetica Neue";
        public boolean rounded = false;
        public boolean border = true;
        public boolean widthFix = true;
        public double aspect = 2.0;

        public boolean equals(Object o) {
            if (!(o instanceof GTS114Sign)) {
                return false;
            }
            GTS114Sign that = (GTS114Sign)o;
            return this.rounded == that.rounded && this.border == that.border && this.widthFix == that.widthFix && Double.compare(this.aspect, that.aspect) == 0 && Objects.equals(this.japanese, that.japanese) && Objects.equals(this.english, that.english) && Objects.equals(this.color, that.color) && Objects.equals(this.textColor, that.textColor) && Objects.equals(this.japaneseFont, that.japaneseFont) && Objects.equals(this.englishFont, that.englishFont);
        }

        public int hashCode() {
            return Objects.hash(this.japanese, this.english, this.color, this.textColor, this.japaneseFont, this.englishFont, this.rounded, this.border, this.widthFix, this.aspect);
        }

        public void readFromNBT(NBTTagCompound compound) {
            this.japanese = compound.func_74779_i("japanese");
            this.english = compound.func_74779_i("english");
            this.japaneseFont = compound.func_74779_i("japanese_font");
            this.englishFont = compound.func_74779_i("english_font");
            this.color = new Color(compound.func_74762_e("color"));
            this.textColor = new Color(compound.func_74762_e("text_color"));
            this.aspect = compound.func_74769_h("aspect");
            this.widthFix = compound.func_74767_n("width_fix");
            this.rounded = compound.func_74767_n("rounded");
            this.border = compound.func_74767_n("border");
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("japanese", this.japanese);
            compound.func_74778_a("english", this.english);
            compound.func_74778_a("japanese_font", this.japaneseFont);
            compound.func_74778_a("english_font", this.englishFont);
            compound.func_74768_a("color", this.color.getRGB());
            compound.func_74768_a("text_color", this.textColor.getRGB());
            compound.func_74780_a("aspect", this.aspect);
            compound.func_74757_a("width_fix", this.widthFix);
            compound.func_74757_a("rounded", this.rounded);
            compound.func_74757_a("border", this.border);
            return compound;
        }
    }
}

