/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.minecraft.tileentity;

import com.gfactory.core.helper.GNBTHelper;
import com.gfactory.core.mqo.MQO;
import com.gfactory.core.mqo.MQOObject;
import com.gfactory.core.mqo.MQOVertex;
import com.gfactory.gts.minecraft.GTS;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntityDummy;
import com.gfactory.gts.pack.GTSPack;
import com.gfactory.gts.pack.config.GTSConfig;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;

public abstract class GTSTileEntity<T extends GTSConfig>
extends TileEntity {
    protected GTSPack pack;
    protected T config;
    protected double angle;
    protected double posX;
    protected double posY;
    protected double posZ;
    protected transient double[][] modelMinMax;

    public abstract String getName();

    public abstract void setDummy();

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.angle = GNBTHelper.getDoubleWithValue(compound, "gts_angle", 0.0);
        this.posX = GNBTHelper.getDoubleWithValue(compound, "gts_pos_x", 0.0);
        this.posY = GNBTHelper.getDoubleWithValue(compound, "gts_pos_y", 0.0);
        this.posZ = GNBTHelper.getDoubleWithValue(compound, "gts_pos_z", 0.0);
        String packName = compound.func_74779_i("gts_pack_name");
        String packConfig = compound.func_74779_i("gts_pack_config");
        GTSPack p = GTS.LOADER.getPack(packName);
        if (p == null) {
            GTS.LOGGER.warn(I18n.func_135052_a((String)"gts.warning.nbt_cannot_load", (Object[])new Object[]{"pack", packName}));
            this.setDummy();
        } else {
            for (Map.Entry<String, GTSConfig<GTSConfig.GTSTexture>> c : p.getConfigs().entrySet()) {
                GTSConfig<GTSConfig.GTSTexture> cc = c.getValue();
                if (!cc.getId().equals(packConfig)) continue;
                this.pack = p;
                this.config = cc;
            }
        }
        this.readDataFromNBT(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound result = compound;
        if (!(this instanceof GTSTileEntityDummy)) {
            result = super.func_189515_b(compound);
        } else if (this.field_174879_c != null) {
            result.func_74768_a("x", this.field_174879_c.func_177958_n());
            result.func_74768_a("y", this.field_174879_c.func_177956_o());
            result.func_74768_a("z", this.field_174879_c.func_177952_p());
        }
        result.func_74778_a("gts_pack_name", this.pack.getName());
        result.func_74778_a("gts_pack_config", ((GTSConfig)this.config).getId());
        result.func_74780_a("gts_angle", this.angle);
        result.func_74780_a("gts_pos_x", this.posX);
        result.func_74780_a("gts_pos_y", this.posY);
        result.func_74780_a("gts_pos_z", this.posZ);
        result = this.writeDataToNBT(result);
        return result;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public abstract void readDataFromNBT(NBTTagCompound var1);

    public abstract NBTTagCompound writeDataToNBT(NBTTagCompound var1);

    public double getAngle() {
        return this.angle;
    }

    public T getConfig() {
        return this.config;
    }

    public GTSPack getPack() {
        return this.pack;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public void setConfig(T config) {
        this.config = config;
        this.posX = ((GTSConfig)this.config).getOriginalPosition()[0];
        this.posY = ((GTSConfig)this.config).getOriginalPosition()[1];
        this.posZ = ((GTSConfig)this.config).getOriginalPosition()[2];
        this.func_70296_d();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 15);
        }
    }

    public void setPack(GTSPack pack) {
        this.pack = pack;
    }

    public double getPosX() {
        return this.posX;
    }

    public void setPosX(double posX) {
        this.posX = posX;
    }

    public double getPosY() {
        return this.posY;
    }

    public void setPosY(double posY) {
        this.posY = posY;
    }

    public double getPosZ() {
        return this.posZ;
    }

    public void setPosZ(double posZ) {
        this.posZ = posZ;
    }

    public boolean equals(Object obj) {
        return obj instanceof GTSTileEntity && this.field_174879_c != null && this.field_174879_c.equals((Object)((GTSTileEntity)((Object)obj)).field_174879_c);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB aabb = super.getRenderBoundingBox();
        if (this.pack == null || this.config == null) {
            return aabb;
        }
        MQO model = this.pack.getResizingModels(((GTSConfig)this.config).getModel(), ((GTSConfig)this.config).getSize());
        for (MQOObject o : model.getObjects()) {
            MQOVertex[] r = o.getBoundingBox();
            aabb.func_111270_a(new AxisAlignedBB(r[0].getX(), r[0].getY(), r[0].getZ(), r[1].getX(), r[1].getY(), r[1].getZ()));
        }
        return aabb;
    }

    protected void calcModelMinMax() {
        if (this.pack == null || this.config == null) {
            return;
        }
        MQO model = this.pack.getResizingModels(((GTSConfig)this.config).getModel(), ((GTSConfig)this.config).getSize());
        double[][] result = new double[][]{{0.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}};
        for (MQOObject o : model.getObjects()) {
            double[][] r = o.getAxisMinMax();
            double[] dArray = result[0];
            dArray[0] = dArray[0] + r[0][0];
            double[] dArray2 = result[1];
            dArray2[0] = dArray2[0] + r[1][0];
            double[] dArray3 = result[2];
            dArray3[0] = dArray3[0] + r[2][0];
            double[] dArray4 = result[0];
            dArray4[1] = dArray4[1] + r[0][1];
            double[] dArray5 = result[1];
            dArray5[1] = dArray5[1] + r[1][1];
            double[] dArray6 = result[2];
            dArray6[1] = dArray6[1] + r[2][1];
        }
        this.modelMinMax = result;
    }

    public double[][] getModelMinMax() {
        if (this.modelMinMax == null) {
            this.calcModelMinMax();
        }
        return this.modelMinMax;
    }

    public double func_145833_n() {
        return Math.pow(128.0, 2.0);
    }
}

