/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.minecraft.renderer;

import com.gfactory.core.mqo.MQO;
import com.gfactory.gts.minecraft.GTS;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntity;
import com.gfactory.gts.pack.GTSPack;
import com.gfactory.gts.pack.config.GTSConfig;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public abstract class GTSTileEntityRenderer<T extends GTSTileEntity, U extends GTSConfig>
extends TileEntitySpecialRenderer<GTSTileEntity> {
    public void render(GTSTileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        MQO model;
        super.func_192841_a((TileEntity)te, x, y, z, partialTicks, destroyStage, alpha);
        GL11.glPushMatrix();
        Object config = te.getConfig();
        GTSPack pack = te.getPack();
        if (pack == null) {
            GL11.glPopMatrix();
        }
        if ((model = pack.getResizingModels(((GTSConfig)config).getModel(), ((GTSConfig)config).getSize())) == null) {
            GTS.LOGGER.warn(I18n.func_135052_a((String)"gts.warning.model_cannot_load", (Object[])new Object[]{((GTSConfig)config).getModel()}));
            GL11.glPopMatrix();
            return;
        }
        GlStateManager.func_179091_B();
        GlStateManager.func_179145_e();
        GlStateManager.func_179103_j((int)7425);
        GL11.glTranslated((double)(x + 0.5 + te.getPosX() * Math.cos(te.getAngle()) + te.getPosZ() * Math.sin(te.getAngle())), (double)(y + 0.5 + te.getPosY()), (double)(z + 0.5 + te.getPosZ() * Math.cos(te.getAngle()) + te.getPosX() * Math.sin(te.getAngle())));
        GL11.glRotated((double)te.getAngle(), (double)0.0, (double)1.0, (double)0.0);
        this.renderModel(te, pack, config, Tessellator.func_178181_a(), model, x, y, z, partialTicks, destroyStage, alpha);
        GlStateManager.func_179103_j((int)7424);
        GL11.glPopMatrix();
    }

    public abstract void renderModel(T var1, GTSPack var2, U var3, Tessellator var4, MQO var5, double var6, double var8, double var10, float var12, int var13, float var14);
}

