/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.tool.event;

import com.gfactory.gts.tool.GTSPackMaker;
import com.gfactory.gts.tool.helper.I18n;
import com.gfactory.gts.tool.project.GTSPackProject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ProjectEvent {
    public static void createProject() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        int result = chooser.showDialog(GTSPackMaker.window, I18n.format("open", new String[0]));
        if (result == 1 || result == -1) {
            return;
        }
        File projectFile = chooser.getSelectedFile();
        GTSPackMaker.project = new GTSPackProject(projectFile);
        GTSPackMaker.statusBar.setText(I18n.format("status.scanProject", projectFile.getAbsolutePath()));
        GTSPackMaker.sideView.createTreeModel(projectFile);
        GTSPackMaker.menuBar.revalidate();
    }

    public static void importProject() {
        JFileChooser chooser = new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(new FileNameExtensionFilter(I18n.format("file.zip", new String[0]), "zip"));
        int result = chooser.showDialog(GTSPackMaker.window, I18n.format("open", new String[0]));
        if (result == 1 || result == -1) {
            return;
        }
        JOptionPane.showMessageDialog(GTSPackMaker.window, "\u958b\u767a\u4e2d\u3067\u3059");
    }

    public static void exportPack() {
        JFileChooser chooser = new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(new FileNameExtensionFilter(I18n.format("file.zip", new String[0]), "zip"));
        int result = chooser.showDialog(GTSPackMaker.window, I18n.format("save", new String[0]));
        if (result == 1 || result == -1) {
            return;
        }
        File file = chooser.getSelectedFile();
        try (FileOutputStream fos = new FileOutputStream(file);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            ProjectEvent.writeZipEntries(GTSPackMaker.project.getProjectDirectory(), GTSPackMaker.project.getProjectDirectory(), zos);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(GTSPackMaker.window, I18n.format("message.failed", "\u30a8\u30af\u30b9\u30dd\u30fc\u30c8", e.getLocalizedMessage()), I18n.format("message.title.failed", new String[0]), 0);
        }
    }

    private static void writeZipEntries(File root, File file, ZipOutputStream zos) throws IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            for (File child : files) {
                ProjectEvent.writeZipEntries(root, child, zos);
            }
        } else {
            String name = root.toURI().relativize(file.toURI()).getPath();
            zos.putNextEntry(new ZipEntry(name));
            try (FileInputStream fis = new FileInputStream(file);){
                int read;
                byte[] buffer = new byte[4096];
                while ((read = fis.read(buffer)) != -1) {
                    zos.write(buffer, 0, read);
                }
            }
            zos.closeEntry();
        }
    }
}

