/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.minecraft.tileentity;

import com.gfactory.gts.common.controller.GTSCycle;
import com.gfactory.gts.common.controller.GTSFixCycle;
import com.gfactory.gts.minecraft.GTS;
import com.gfactory.gts.minecraft.network.packet.GTSPacketTileEntity;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntity;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntityTrafficButton;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntityTrafficLight;
import com.gfactory.gts.minecraft.tileentity.IGTSAttachable;
import com.gfactory.gts.pack.GTSPack;
import com.gfactory.gts.pack.config.GTSTrafficControllerConfig;
import com.gfactory.gts.pack.config.GTSTrafficLightConfig;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class GTSTileEntityTrafficController
extends GTSTileEntity<GTSTrafficControllerConfig>
implements ITickable,
IGTSAttachable<GTSTileEntity> {
    private ArrayList<GTSCycle> cycles = new ArrayList();
    private int nowCycle = 0;
    private boolean detected = false;
    private ArrayList<BlockPos> attachedTrafficLights = new ArrayList();
    private ArrayList<BlockPos> attachedTrafficButtons = new ArrayList();

    public GTSTileEntityTrafficController() {
        this.setDummy();
    }

    @Override
    public String getName() {
        return I18n.func_135052_a((String)"tile.traffic_controller.name", (Object[])new Object[0]);
    }

    @Override
    public void setDummy() {
        GTSPack p = GTS.LOADER.getDummy();
        if (p == null) {
            throw new RuntimeException("Dummy Model cannot be loaded.");
        }
        this.pack = p;
        GTSTrafficControllerConfig config = new GTSTrafficControllerConfig();
        config.setDummy();
        this.setConfig(config);
        GTSTrafficLightConfig.GTSTrafficLightPattern carGreen = new GTSTrafficLightConfig.GTSTrafficLightPattern();
        carGreen.getObjects().add("g300");
        carGreen.getObjects().add("g250");
        GTSTrafficLightConfig.GTSTrafficLightPattern carYellow = new GTSTrafficLightConfig.GTSTrafficLightPattern();
        carYellow.getObjects().add("y300");
        carYellow.getObjects().add("y250");
        GTSTrafficLightConfig.GTSTrafficLightPattern carRed = new GTSTrafficLightConfig.GTSTrafficLightPattern();
        carRed.getObjects().add("r300");
        carRed.getObjects().add("r250");
        GTSTrafficLightConfig.GTSTrafficLightPattern pedGreen = new GTSTrafficLightConfig.GTSTrafficLightPattern();
        pedGreen.getObjects().add("g");
        GTSTrafficLightConfig.GTSTrafficLightPattern pedFlush = new GTSTrafficLightConfig.GTSTrafficLightPattern();
        pedFlush.getObjects().add("g");
        pedFlush.setTick(10);
        GTSTrafficLightConfig.GTSTrafficLightPattern pedRed = new GTSTrafficLightConfig.GTSTrafficLightPattern();
        pedRed.getObjects().add("r");
        this.cycles.add(new GTSFixCycle("mainCar", "subCar", "mainPed", "subPed", carGreen, carYellow, carRed, pedGreen, pedFlush, pedRed));
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        NBTTagCompound tag;
        int i;
        this.detected = compound.func_74767_n("gts_detected");
        this.nowCycle = compound.func_74762_e("gts_nowCycle");
        ArrayList<BlockPos> pos = new ArrayList<BlockPos>();
        for (i = 0; i < compound.func_150295_c("gts_attached_traffic_light", 10).func_74745_c(); ++i) {
            tag = compound.func_150295_c("gts_attached_traffic_light", 10).func_150305_b(i);
            pos.add(new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z")));
        }
        this.attachedTrafficLights = pos;
        pos = new ArrayList();
        for (i = 0; i < compound.func_150295_c("gts_attached_traffic_button", 10).func_74745_c(); ++i) {
            tag = compound.func_150295_c("gts_attached_traffic_button", 10).func_150305_b(i);
            pos.add(new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z")));
        }
        this.attachedTrafficButtons = pos;
        if (compound.func_74764_b("gts_cycles")) {
            Type listType = new TypeToken<ArrayList<GTSCycle>>(){}.getType();
            this.cycles = (ArrayList)GTS.GSON.fromJson(compound.func_74779_i("gts_cycles"), listType);
        }
    }

    @Override
    public NBTTagCompound writeDataToNBT(NBTTagCompound compound) {
        NBTTagCompound c;
        compound.func_74757_a("gts_detected", this.detected);
        compound.func_74768_a("gts_nowCycle", this.nowCycle);
        NBTTagList list = new NBTTagList();
        for (BlockPos pos : this.attachedTrafficLights) {
            c = new NBTTagCompound();
            c.func_74768_a("x", pos.func_177958_n());
            c.func_74768_a("y", pos.func_177956_o());
            c.func_74768_a("z", pos.func_177952_p());
            list.func_74742_a((NBTBase)c);
        }
        compound.func_74782_a("gts_attached_traffic_light", (NBTBase)list);
        list = new NBTTagList();
        for (BlockPos pos : this.attachedTrafficButtons) {
            c = new NBTTagCompound();
            c.func_74768_a("x", pos.func_177958_n());
            c.func_74768_a("y", pos.func_177956_o());
            c.func_74768_a("z", pos.func_177952_p());
            list.func_74742_a((NBTBase)c);
        }
        compound.func_74782_a("gts_attached_traffic_button", (NBTBase)list);
        Type listType = new TypeToken<ArrayList<GTSCycle>>(){}.getType();
        compound.func_74778_a("gts_cycles", GTS.GSON.toJson(this.cycles, listType));
        return compound;
    }

    public void func_73660_a() {
        if (this.cycles.isEmpty()) {
            return;
        }
        GTSCycle cycle = this.cycles.get(this.nowCycle);
        boolean finish = cycle.tick(this, this.detected, this.field_145850_b);
        if (finish) {
            for (int i = 0; i < this.cycles.size(); ++i) {
                if (!this.cycles.get(i).canStart(this, this.detected, this.field_145850_b)) continue;
                this.nowCycle = i;
                return;
            }
        }
    }

    public ArrayList<GTSCycle> getCycles() {
        return this.cycles;
    }

    public boolean isDetected() {
        return this.detected;
    }

    public int getNowCycleNumber() {
        return this.nowCycle;
    }

    public GTSCycle getNowCycle() {
        return this.nowCycle >= 0 && this.nowCycle < this.cycles.size() ? this.cycles.get(this.nowCycle) : null;
    }

    public void setCycles(ArrayList<GTSCycle> cycles) {
        this.cycles = cycles;
    }

    public void setDetected(boolean detected) {
        this.detected = detected;
    }

    @Override
    public void attach(GTSTileEntity te) {
        if (te instanceof GTSTileEntityTrafficLight) {
            if (!this.attachedTrafficLights.contains(te.func_174877_v())) {
                this.attachedTrafficLights.add(te.func_174877_v());
            }
        } else if (te instanceof GTSTileEntityTrafficButton && !this.attachedTrafficButtons.contains(te.func_174877_v())) {
            this.attachedTrafficButtons.add(te.func_174877_v());
            ((GTSTileEntityTrafficButton)te).setDetected(this.detected);
        }
        this.func_70296_d();
        if (this.field_145850_b.field_72995_K) {
            GTS.NETWORK.sendToServer(new GTSPacketTileEntity<GTSTileEntityTrafficController>(this.func_189515_b(new NBTTagCompound()), this.field_174879_c, GTSTileEntityTrafficController.class));
        }
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
    }

    @Override
    public void deattach(GTSTileEntity te) {
        if (te instanceof GTSTileEntityTrafficLight) {
            this.attachedTrafficLights.remove(te.func_174877_v());
        } else if (te instanceof GTSTileEntityTrafficButton) {
            this.attachedTrafficButtons.remove(te.func_174877_v());
        }
        this.func_70296_d();
        if (this.field_145850_b.field_72995_K) {
            GTS.NETWORK.sendToServer(new GTSPacketTileEntity<GTSTileEntityTrafficController>(this.func_189515_b(new NBTTagCompound()), this.field_174879_c, GTSTileEntityTrafficController.class));
        }
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
    }

    @Override
    public void reset() {
        this.attachedTrafficLights = new ArrayList();
        this.attachedTrafficButtons = new ArrayList();
        if (this.field_145850_b.field_72995_K) {
            GTS.NETWORK.sendToServer(new GTSPacketTileEntity<GTSTileEntityTrafficController>(this.func_189515_b(new NBTTagCompound()), this.field_174879_c, GTSTileEntityTrafficController.class));
        }
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
    }

    public ArrayList<BlockPos> getAttachedTrafficLights() {
        return this.attachedTrafficLights;
    }

    public void setAttachedTrafficLights(ArrayList<BlockPos> attachedTrafficLights) {
        this.attachedTrafficLights = attachedTrafficLights;
    }

    public ArrayList<BlockPos> getAttachedTrafficButtons() {
        return this.attachedTrafficButtons;
    }

    public void setAttachedTrafficButtons(ArrayList<BlockPos> attachedTrafficButtons) {
        this.attachedTrafficButtons = attachedTrafficButtons;
    }

    public String toString() {
        return "GTSTileEntityTrafficController{pack=" + this.pack + ", config=" + this.config + ", angle=" + this.angle + ", nowCycle=" + this.nowCycle + ", detected=" + this.detected + ", cycles=" + this.cycles + ", attachedTrafficLights=" + this.attachedTrafficLights + "} " + super.toString();
    }
}

