/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.tool.component.tab;

import com.gfactory.gts.tool.GTSPackMaker;
import com.gfactory.gts.tool.helper.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GTSTabTextureView
extends JPanel {
    public GTSTabTextureView(File file) {
        this.setLayout(new BorderLayout());
        try {
            BufferedImage image = ImageIO.read(file);
            TexturePanel panel = new TexturePanel(image);
            this.add((Component)panel, "Center");
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(GTSPackMaker.window, I18n.format("message.failed.texture", new String[0]), I18n.format("message.title.failed", new String[0]), 0);
        }
    }

    public static class TexturePanel
    extends JPanel {
        private BufferedImage image;

        public TexturePanel(BufferedImage image) {
            this.image = image;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            float zoom = Math.min(this.getWidth() / this.image.getWidth(), this.getHeight() / this.image.getHeight());
            g.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), null);
        }
    }
}

