/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.gts.minecraft.tileentity;

import com.gfactory.gts.minecraft.GTS;
import com.gfactory.gts.minecraft.network.packet.GTSPacketTileEntity;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntity;
import com.gfactory.gts.minecraft.tileentity.GTSTileEntityTrafficController;
import com.gfactory.gts.minecraft.tileentity.IGTSAttachable;
import com.gfactory.gts.pack.GTSPack;
import com.gfactory.gts.pack.config.GTSTrafficLightConfig;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class GTSTileEntityTrafficLight
extends GTSTileEntity<GTSTrafficLightConfig>
implements IGTSAttachable<GTSTileEntityTrafficController> {
    private BlockPos attachedTrafficController = null;
    private String channel = "test";

    public GTSTileEntityTrafficLight() {
        this.setDummy();
    }

    @Override
    public String getName() {
        return I18n.func_135052_a((String)"tile.traffic_light.name", (Object[])new Object[0]);
    }

    @Override
    public void setDummy() {
        GTSPack p = GTS.LOADER.getDummy();
        if (p == null) {
            throw new RuntimeException("Dummy Model cannot be loaded.");
        }
        this.pack = p;
        GTSTrafficLightConfig config = new GTSTrafficLightConfig();
        config.setDummy();
        this.setConfig(config);
    }

    public void change(GTSPack pack, GTSTrafficLightConfig config) {
        this.pack = pack;
        this.config = config;
    }

    @Override
    public GTSTrafficLightConfig getConfig() {
        return (GTSTrafficLightConfig)this.config;
    }

    @Override
    public GTSPack getPack() {
        return this.pack;
    }

    @Override
    public double getAngle() {
        return this.angle;
    }

    @Override
    public void setAngle(double angle) {
        this.angle = angle;
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        this.channel = compound.func_74779_i("gts_channel");
        if (compound.func_74764_b("gts_attached_traffic_controller")) {
            this.attachedTrafficController = BlockPos.func_177969_a((long)compound.func_74763_f("gts_attached_traffic_controller"));
        }
    }

    @Override
    public NBTTagCompound writeDataToNBT(NBTTagCompound compound) {
        NBTTagCompound result = compound;
        result.func_74778_a("gts_channel", this.channel);
        if (this.attachedTrafficController != null) {
            result.func_74772_a("gts_attached_traffic_controller", this.attachedTrafficController.func_177986_g());
        }
        return result;
    }

    @Override
    public void attach(GTSTileEntityTrafficController te) {
        this.attachedTrafficController = te.func_174877_v();
        if (this.field_145850_b.field_72995_K) {
            GTS.NETWORK.sendToServer(new GTSPacketTileEntity<GTSTileEntityTrafficLight>(this.func_189515_b(new NBTTagCompound()), this.field_174879_c, GTSTileEntityTrafficLight.class));
        }
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
    }

    @Override
    public void deattach(GTSTileEntityTrafficController te) {
        if (te.func_174877_v().equals((Object)this.attachedTrafficController)) {
            this.attachedTrafficController = null;
            if (this.field_145850_b.field_72995_K) {
                GTS.NETWORK.sendToServer(new GTSPacketTileEntity<GTSTileEntityTrafficLight>(this.func_189515_b(new NBTTagCompound()), this.field_174879_c, GTSTileEntityTrafficLight.class));
            }
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            }
        }
    }

    @Override
    public void reset() {
    }

    public BlockPos getAttachedTrafficController() {
        return this.attachedTrafficController;
    }

    public void setAttachedTrafficController(BlockPos attachedTrafficController) {
        this.attachedTrafficController = attachedTrafficController;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }
}

