/*
 * Decompiled with CFR 0.152.
 */
package com.gfactory.core.mqo;

import com.gfactory.core.mqo.MQOObject;
import com.gfactory.core.mqo.MQOVertex;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;

public final class MQO {
    private BufferedImage thumbnail = null;
    private float version;
    private ArrayList<MQOObject> objects = new ArrayList();

    MQO() {
    }

    public ArrayList<MQOObject> getObjects() {
        return this.objects;
    }

    public void setObjects(ArrayList<MQOObject> objects) {
        this.objects = objects;
    }

    public float getVersion() {
        return this.version;
    }

    public void setVersion(float version) {
        this.version = version;
    }

    void createThumbnailImage(int[][] rawData) throws IOException {
        BufferedImage image = new BufferedImage(rawData.length, rawData[0].length, 5);
        for (int w = 0; w < rawData.length; ++w) {
            for (int h = 0; h < rawData[0].length; ++h) {
                image.setRGB(w, h, rawData[w][h]);
            }
        }
        this.thumbnail = image;
    }

    public BufferedImage getThumbnail() {
        return this.thumbnail;
    }

    public String toString() {
        return "MQO[O=" + this.objects + "]";
    }

    public MQO normalize(double maxSize) {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        for (MQOObject obj : this.objects) {
            for (MQOVertex v : obj.getVertexs()) {
                minX = Math.min(minX, v.getX());
                minY = Math.min(minY, v.getY());
                minZ = Math.min(minZ, v.getZ());
                maxX = Math.max(maxX, v.getX());
                maxY = Math.max(maxY, v.getY());
                maxZ = Math.max(maxZ, v.getZ());
            }
        }
        double centerX = (minX + maxX) / 2.0;
        double centerY = (minY + maxY) / 2.0;
        double centerZ = (minZ + maxZ) / 2.0;
        double lenX = maxX - minX;
        double lenY = maxY - minY;
        double lenZ = maxZ - minZ;
        double maxLen = Math.max(lenX, Math.max(lenY, lenZ));
        double scale = maxSize / maxLen;
        MQO result = new MQO();
        result.setVersion(this.version);
        for (MQOObject obj : this.objects) {
            MQOObject newObj = new MQOObject(obj.getName());
            ArrayList<MQOVertex> newVertexs = new ArrayList<MQOVertex>();
            for (MQOVertex v : obj.getVertexs()) {
                double x = (v.getX() - centerX) * scale;
                double y = (v.getY() - centerY) * scale;
                double z = (v.getZ() - centerZ) * scale;
                newVertexs.add(new MQOVertex(x, y, z));
            }
            newObj.setVertexs(newVertexs);
            newObj.setFaces(obj.getFaces());
            result.getObjects().add(newObj);
        }
        return result;
    }
}

